package gov.va.med.mhv.admin.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.admin.dto.ApiCategoryDTO;
import gov.va.med.mhv.admin.model.ApiCategory;

import org.springframework.core.convert.converter.Converter;

public class ApiCategoryConverter implements Converter<ApiCategory, ApiCategoryDTO> {

	@Override
	public ApiCategoryDTO convert(ApiCategory source) {
		ApiCategoryDTO target = new ApiCategoryDTO();
		target.setApiCatId(source.getApiCatId());
		target.setApiCatName(source.getApiCatName());
		target.setDeleted(source.getDeleted());
		return target;
	}

	public ApiCategory convert(ApiCategoryDTO source) {
		ApiCategory target = new ApiCategory();
		target.setApiCatId(source.getApiCatId());
		target.setApiCatName(source.getApiCatName());
		target.setDeleted(source.getDeleted());
		return target;
	}

	public List<ApiCategoryDTO> convert(List<ApiCategory> source) {
		List<ApiCategoryDTO> apiCatDto = null;
		if (null != source) {
			apiCatDto = new ArrayList<ApiCategoryDTO>();

			for (ApiCategory calViewApiCat : source) {
				apiCatDto.add(this.convert(calViewApiCat));
			}

		}

		return apiCatDto;
	}

}
